var DiagnosticsHub = this.Microsoft.VisualStudio.DiagnosticsHub;
var VisualProfiler;
(function (VisualProfiler) {
    var VisualProfilerController = (function () {
        function VisualProfilerController() {
            var _this = this;
            this._view = new VisualProfilerView(this);
            var hubDataWarehouse = DiagnosticsHub.DataWarehouse.getDataWarehouseService();
            hubDataWarehouse.getAllDataSourceInfos(function (result) {
                var etlPath;
                for(var i = 0; i < result.length; i++) {
                    var dataSource = result[i];
                    if(dataSource.type == DiagnosticsHub.DataWarehouse.DataSourceInfoType.File && dataSource.identity == DiagnosticsHub.DataWarehouse.DataSourceIdentity.EtlFile) {
                        etlPath = dataSource.path;
                        break;
                    }
                }
                if(etlPath) {
                    _this._view.setEtlPath(etlPath);
                }
            });
        }
        VisualProfilerController.prototype.initializeSession = function (etlFilePath, completedCallback, failedCallback, progressCallback) {
            var _this = this;
            VisualProfiler.Program.dataWarehouse.createSession(etlFilePath, function (session) {
                var totalDuration = session.getTotalDuration();
                _this._globalRuler = new VisualProfiler.GlobalRuler(new VisualProfiler.TimeSpan(VisualProfiler.TimeStamp.fromNanoseconds(totalDuration.begin), VisualProfiler.TimeStamp.fromNanoseconds(totalDuration.end)));
                _this._toolbarViewModel = new VisualProfiler.ToolbarViewModel(_this._globalRuler);
                var markEventModel = new VisualProfiler.MarkEventModel(session);
                _this._graphRulerViewModel = new VisualProfiler.RulerViewModel(_this._globalRuler, markEventModel);
                var cpuUsageModel = new VisualProfiler.CpuUsageModel(session);
                _this._cpuUsageViewModel = new VisualProfiler.CpuUsageViewModel(cpuUsageModel, _this._globalRuler);
                var frameRateModel = new VisualProfiler.FrameRateModel(session);
                _this._frameRateViewModel = new VisualProfiler.FrameRateViewModel(frameRateModel, _this._globalRuler);
                var eventTimelineModel = new VisualProfiler.EventsTimelineModel(session);
                _this._eventTimelineViewModel = new VisualProfiler.EventsTimelineViewModel(eventTimelineModel, _this._globalRuler, markEventModel);
                _this._frameRateViewModel.leftPadding = _this._cpuUsageViewModel.yAxisWidth = _this._graphRulerViewModel.leftPadding = 34;
                _this._frameRateViewModel.rightPadding = _this._cpuUsageViewModel.rightPadding = _this._graphRulerViewModel.rightPadding = 34;
                if(completedCallback) {
                    completedCallback(_this._globalRuler, _this._graphRulerViewModel, _this._cpuUsageViewModel, _this._frameRateViewModel, _this._eventTimelineViewModel, _this._toolbarViewModel);
                }
            }, function (err) {
                if(failedCallback) {
                    failedCallback(err);
                }
            }, function (progress) {
                if(progressCallback) {
                    progressCallback(progress);
                }
            });
        };
        return VisualProfilerController;
    })();
    VisualProfiler.VisualProfilerController = VisualProfilerController;    
    var VisualProfilerView = (function () {
        function VisualProfilerView(controller) {
            this._controller = controller;
            this._mainContainer = new Common.Controls.Control(document.getElementById("mainContainer"));
            this._mainView = new Common.Controls.TemplateControl("mainViewTemplate");
            this._statusView = this._mainView.findElement("statusView");
            var statusTextSpan = this._mainView.findElement("statusText");
            statusTextSpan.innerText = Plugin.Resources.getString("AnalyzeDataStatus");
            this._statusView.style.display = "none";
            var loadFileView = this._mainView.findElement("loadFileView");
            if(VisualProfiler.Program.userSettings.allowBrowseForETLFile) {
                loadFileView.style.display = "block";
            } else {
                loadFileView.style.display = "none";
            }
            this._inputFile = this._mainView.findElement("inputFile");
            this._processButton = this._mainView.findElement("processButton");
            this._progress = this._mainView.findElement("progress");
            this._mainContainer.appendChild(this._mainView);
            this._toolbarView = new VisualProfiler.ToolbarView(this._mainView.findElement("toolbarViewContainer").id);
            this._graphRulerView = new VisualProfiler.RulerView(this._mainView.findElement("graphRulerView").id);
            this._cpuUsageView = new VisualProfiler.CpuUsageView(this._mainView.findElement("cpuViewContainer").id);
            this._frameRateView = new VisualProfiler.FrameRateView(this._mainView.findElement("frameRateContainer").id);
            this._eventsTimelineView = new VisualProfiler.EventsTimelineView(this._mainView.findElement("timelineViewContainer").id);
            this._graphRulerView.minSelectionWidthInPixels = VisualProfilerView._minSelectionWidthInPixels;
            this._cpuUsageView.minSelectionWidthInPixels = VisualProfilerView._minSelectionWidthInPixels;
            this._frameRateView.minSelectionWidthInPixels = VisualProfilerView._minSelectionWidthInPixels;
            this._processButton.onclick = this.onProcessButtonClick.bind(this);
        }
        VisualProfilerView._minSelectionWidthInPixels = 10;
        VisualProfilerView.prototype.setEtlPath = function (etlPath) {
            var _this = this;
            var progressSoFar = 0;
            var progressStageNumber = 0;
            this._progress.value = 0;
            this._progress.max = 100;
            this._controller.initializeSession(etlPath, function (globalRuler, graphRulerViewModel, cpuUsageViewModel, frameRateViewModel, eventsTimelineViewModel, toolbarViewModel) {
                _this._statusView.style.display = "none";
                _this._toolbarView.setViewModel(toolbarViewModel);
                _this._graphRulerView.viewModel = graphRulerViewModel;
                _this._graphRulerView.render();
                _this._cpuUsageView.viewModel = cpuUsageViewModel;
                _this._cpuUsageView.render();
                _this._frameRateView.viewModel = frameRateViewModel;
                _this._frameRateView.render();
                _this._eventsTimelineView.viewModel = eventsTimelineViewModel;
                _this._eventsTimelineView.render();
                Plugin.VS.Internal.CodeMarkers.fire(VisualProfiler.CodeMarkerValues.perfBrowserTools_VisualProfilerResultsLoaded);
            }, function (errorCode) {
                _this.showError(errorCode);
            }, function (progress) {
                _this._statusView.style.display = "block";
                if(progressStageNumber !== progress.currentStage) {
                    progressStageNumber = progress.currentStage;
                    progressSoFar = _this._progress.value;
                }
                var stagePrecentage = (progress.value / progress.max) * 100;
                var stageTotalContribution = stagePrecentage / progress.totalStages;
                _this._progress.value = progressSoFar + stageTotalContribution;
            });
        };
        VisualProfilerView.prototype.onProcessButtonClick = function () {
            if(!this._inputFile.value) {
                return;
            }
            this.setEtlPath(this._inputFile.value);
        };
        VisualProfilerView.prototype.showError = function (errorCode) {
            var errorView = new Common.Controls.TemplateControl("errorViewTemplate");
            var errorMessageDiv = errorView.findElement("errorMessage");
            errorMessageDiv.innerText = Plugin.Resources.getString("GenericDataProcessingError", errorCode);
            this._mainContainer.removeChild(this._mainView);
            this._mainContainer.appendChild(errorView);
        };
        return VisualProfilerView;
    })();
    VisualProfiler.VisualProfilerView = VisualProfilerView;    
})(VisualProfiler || (VisualProfiler = {}));
var visualProfilerController;
this.VisualProfiler.Program.addEventListener("initialized", function () {
    visualProfilerController = new VisualProfiler.VisualProfilerController();
});
//@ sourceMappingURL=VisualProfiler.js.map

// SIG // Begin signature block
// SIG // MIIamQYJKoZIhvcNAQcCoIIaijCCGoYCAQExCzAJBgUr
// SIG // DgMCGgUAMGcGCisGAQQBgjcCAQSgWTBXMDIGCisGAQQB
// SIG // gjcCAR4wJAIBAQQQEODJBs441BGiowAQS9NQkAIBAAIB
// SIG // AAIBAAIBAAIBADAhMAkGBSsOAwIaBQAEFNFMSFMeamFe
// SIG // 89fxMH3nU4yWaRTYoIIVeTCCBLowggOioAMCAQICCmEC
// SIG // jkIAAAAAAB8wDQYJKoZIhvcNAQEFBQAwdzELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9zb2Z0IFRp
// SIG // bWUtU3RhbXAgUENBMB4XDTEyMDEwOTIyMjU1OFoXDTEz
// SIG // MDQwOTIyMjU1OFowgbMxCzAJBgNVBAYTAlVTMRMwEQYD
// SIG // VQQIEwpXYXNoaW5ndG9uMRAwDgYDVQQHEwdSZWRtb25k
// SIG // MR4wHAYDVQQKExVNaWNyb3NvZnQgQ29ycG9yYXRpb24x
// SIG // DTALBgNVBAsTBE1PUFIxJzAlBgNVBAsTHm5DaXBoZXIg
// SIG // RFNFIEVTTjpGNTI4LTM3NzctOEE3NjElMCMGA1UEAxMc
// SIG // TWljcm9zb2Z0IFRpbWUtU3RhbXAgU2VydmljZTCCASIw
// SIG // DQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAJbsjkdN
// SIG // VMJclYDXTgs9v5dDw0vjYGcRLwFNDNjRRi8QQN4LpFBS
// SIG // EogLQ3otP+5IbmbHkeYDym7sealqI5vNYp7NaqQ/56ND
// SIG // /2JHobS6RPrfQMGFVH7ooKcsQyObUh8yNfT+mlafjWN3
// SIG // ezCeCjOFchvKSsjMJc3bXREux7CM8Y9DSEcFtXogC+Xz
// SIG // 78G69LPYzTiP+yGqPQpthRfQyueGA8Azg7UlxMxanMTD
// SIG // 2mIlTVMlFGGP+xvg7PdHxoBF5jVTIzZ3yrDdmCs5wHU1
// SIG // D92BTCE9djDFsrBlcylIJ9jC0rCER7t4utV0A97XSxn3
// SIG // U9542ob3YYgmM7RHxqBUiBUrLHUCAwEAAaOCAQkwggEF
// SIG // MB0GA1UdDgQWBBQv6EbIaNNuT7Ig0N6JTvFH7kjB8jAf
// SIG // BgNVHSMEGDAWgBQjNPjZUkZwCu1A+3b7syuwwzWzDzBU
// SIG // BgNVHR8ETTBLMEmgR6BFhkNodHRwOi8vY3JsLm1pY3Jv
// SIG // c29mdC5jb20vcGtpL2NybC9wcm9kdWN0cy9NaWNyb3Nv
// SIG // ZnRUaW1lU3RhbXBQQ0EuY3JsMFgGCCsGAQUFBwEBBEww
// SIG // SjBIBggrBgEFBQcwAoY8aHR0cDovL3d3dy5taWNyb3Nv
// SIG // ZnQuY29tL3BraS9jZXJ0cy9NaWNyb3NvZnRUaW1lU3Rh
// SIG // bXBQQ0EuY3J0MBMGA1UdJQQMMAoGCCsGAQUFBwMIMA0G
// SIG // CSqGSIb3DQEBBQUAA4IBAQBz/30unc2NiCt8feNeFXHp
// SIG // aGLwCLZDVsRcSi1o2PlIEZHzEZyF7BLUVKB1qTihWX91
// SIG // 7sb1NNhUpOLQzHyXq5N1MJcHHQRTLDZ/f/FAHgybgOIS
// SIG // CiA6McAHdWfg+jSc7Ij7VxzlWGIgkEUvXUWpyI6zfHJt
// SIG // ECfFS9hvoqgSs201I2f6LNslLbldsR4F50MoPpwFdnfx
// SIG // Jd4FRxlt3kmFodpKSwhGITWodTZMt7MIqt+3K9m+Kmr9
// SIG // 3zUXzD8Mx90Gz06UJGMgCy4krl9DRBJ6XN0326RFs5E6
// SIG // Eld940fGZtPPnEZW9EwHseAMqtX21Tyi4LXU+Bx+BFUQ
// SIG // axj0kc1Rp5VlMIIE7DCCA9SgAwIBAgITMwAAALARrwqL
// SIG // 0Duf3QABAAAAsDANBgkqhkiG9w0BAQUFADB5MQswCQYD
// SIG // VQQGEwJVUzETMBEGA1UECBMKV2FzaGluZ3RvbjEQMA4G
// SIG // A1UEBxMHUmVkbW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0
// SIG // IENvcnBvcmF0aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQg
// SIG // Q29kZSBTaWduaW5nIFBDQTAeFw0xMzAxMjQyMjMzMzla
// SIG // Fw0xNDA0MjQyMjMzMzlaMIGDMQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMQ0wCwYDVQQLEwRNT1BSMR4wHAYDVQQDExVNaWNy
// SIG // b3NvZnQgQ29ycG9yYXRpb24wggEiMA0GCSqGSIb3DQEB
// SIG // AQUAA4IBDwAwggEKAoIBAQDor1yiIA34KHy8BXt/re7r
// SIG // dqwoUz8620B9s44z5lc/pVEVNFSlz7SLqT+oN+EtUO01
// SIG // Fk7vTXrbE3aIsCzwWVyp6+HXKXXkG4Unm/P4LZ5BNisL
// SIG // QPu+O7q5XHWTFlJLyjPFN7Dz636o9UEVXAhlHSE38Cy6
// SIG // IgsQsRCddyKFhHxPuRuQsPWj/ov0DJpOoPXJCiHiquMB
// SIG // Nkf9L4JqgQP1qTXclFed+0vUDoLbOI8S/uPWenSIZOFi
// SIG // xCUuKq6dGB8OHrbCryS0DlC83hyTXEmmebW22875cHso
// SIG // AYS4KinPv6kFBeHgD3FN/a1cI4Mp68fFSsjoJ4TTfsZD
// SIG // C5UABbFPZXHFAgMBAAGjggFgMIIBXDATBgNVHSUEDDAK
// SIG // BggrBgEFBQcDAzAdBgNVHQ4EFgQUWXGmWjNN2pgHgP+E
// SIG // Hr6H+XIyQfIwUQYDVR0RBEowSKRGMEQxDTALBgNVBAsT
// SIG // BE1PUFIxMzAxBgNVBAUTKjMxNTk1KzRmYWYwYjcxLWFk
// SIG // MzctNGFhMy1hNjcxLTc2YmMwNTIzNDRhZDAfBgNVHSME
// SIG // GDAWgBTLEejK0rQWWAHJNy4zFha5TJoKHzBWBgNVHR8E
// SIG // TzBNMEugSaBHhkVodHRwOi8vY3JsLm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NybC9wcm9kdWN0cy9NaWNDb2RTaWdQQ0Ff
// SIG // MDgtMzEtMjAxMC5jcmwwWgYIKwYBBQUHAQEETjBMMEoG
// SIG // CCsGAQUFBzAChj5odHRwOi8vd3d3Lm1pY3Jvc29mdC5j
// SIG // b20vcGtpL2NlcnRzL01pY0NvZFNpZ1BDQV8wOC0zMS0y
// SIG // MDEwLmNydDANBgkqhkiG9w0BAQUFAAOCAQEAMdduKhJX
// SIG // M4HVncbr+TrURE0Inu5e32pbt3nPApy8dmiekKGcC8N/
// SIG // oozxTbqVOfsN4OGb9F0kDxuNiBU6fNutzrPJbLo5LEV9
// SIG // JBFUJjANDf9H6gMH5eRmXSx7nR2pEPocsHTyT2lrnqkk
// SIG // hNrtlqDfc6TvahqsS2Ke8XzAFH9IzU2yRPnwPJNtQtjo
// SIG // fOYXoJtoaAko+QKX7xEDumdSrcHps3Om0mPNSuI+5PNO
// SIG // /f+h4LsCEztdIN5VP6OukEAxOHUoXgSpRm3m9Xp5QL0f
// SIG // zehF1a7iXT71dcfmZmNgzNWahIeNJDD37zTQYx2xQmdK
// SIG // Dku/Og7vtpU6pzjkJZIIpohmgjCCBbwwggOkoAMCAQIC
// SIG // CmEzJhoAAAAAADEwDQYJKoZIhvcNAQEFBQAwXzETMBEG
// SIG // CgmSJomT8ixkARkWA2NvbTEZMBcGCgmSJomT8ixkARkW
// SIG // CW1pY3Jvc29mdDEtMCsGA1UEAxMkTWljcm9zb2Z0IFJv
// SIG // b3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MB4XDTEwMDgz
// SIG // MTIyMTkzMloXDTIwMDgzMTIyMjkzMloweTELMAkGA1UE
// SIG // BhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24xEDAOBgNV
// SIG // BAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jvc29mdCBD
// SIG // b3Jwb3JhdGlvbjEjMCEGA1UEAxMaTWljcm9zb2Z0IENv
// SIG // ZGUgU2lnbmluZyBQQ0EwggEiMA0GCSqGSIb3DQEBAQUA
// SIG // A4IBDwAwggEKAoIBAQCycllcGTBkvx2aYCAgQpl2U2w+
// SIG // G9ZvzMvx6mv+lxYQ4N86dIMaty+gMuz/3sJCTiPVcgDb
// SIG // NVcKicquIEn08GisTUuNpb15S3GbRwfa/SXfnXWIz6pz
// SIG // RH/XgdvzvfI2pMlcRdyvrT3gKGiXGqelcnNW8ReU5P01
// SIG // lHKg1nZfHndFg4U4FtBzWwW6Z1KNpbJpL9oZC/6SdCni
// SIG // di9U3RQwWfjSjWL9y8lfRjFQuScT5EAwz3IpECgixzdO
// SIG // PaAyPZDNoTgGhVxOVoIoKgUyt0vXT2Pn0i1i8UU956wI
// SIG // APZGoZ7RW4wmU+h6qkryRs83PDietHdcpReejcsRj1Y8
// SIG // wawJXwPTAgMBAAGjggFeMIIBWjAPBgNVHRMBAf8EBTAD
// SIG // AQH/MB0GA1UdDgQWBBTLEejK0rQWWAHJNy4zFha5TJoK
// SIG // HzALBgNVHQ8EBAMCAYYwEgYJKwYBBAGCNxUBBAUCAwEA
// SIG // ATAjBgkrBgEEAYI3FQIEFgQU/dExTtMmipXhmGA7qDFv
// SIG // pjy82C0wGQYJKwYBBAGCNxQCBAweCgBTAHUAYgBDAEEw
// SIG // HwYDVR0jBBgwFoAUDqyCYEBWJ5flJRP8KuEKU5VZ5KQw
// SIG // UAYDVR0fBEkwRzBFoEOgQYY/aHR0cDovL2NybC5taWNy
// SIG // b3NvZnQuY29tL3BraS9jcmwvcHJvZHVjdHMvbWljcm9z
// SIG // b2Z0cm9vdGNlcnQuY3JsMFQGCCsGAQUFBwEBBEgwRjBE
// SIG // BggrBgEFBQcwAoY4aHR0cDovL3d3dy5taWNyb3NvZnQu
// SIG // Y29tL3BraS9jZXJ0cy9NaWNyb3NvZnRSb290Q2VydC5j
// SIG // cnQwDQYJKoZIhvcNAQEFBQADggIBAFk5Pn8mRq/rb0Cx
// SIG // MrVq6w4vbqhJ9+tfde1MOy3XQ60L/svpLTGjI8x8UJiA
// SIG // IV2sPS9MuqKoVpzjcLu4tPh5tUly9z7qQX/K4QwXacul
// SIG // nCAt+gtQxFbNLeNK0rxw56gNogOlVuC4iktX8pVCnPHz
// SIG // 7+7jhh80PLhWmvBTI4UqpIIck+KUBx3y4k74jKHK6BOl
// SIG // kU7IG9KPcpUqcW2bGvgc8FPWZ8wi/1wdzaKMvSeyeWNW
// SIG // RKJRzfnpo1hW3ZsCRUQvX/TartSCMm78pJUT5Otp56mi
// SIG // LL7IKxAOZY6Z2/Wi+hImCWU4lPF6H0q70eFW6NB4lhhc
// SIG // yTUWX92THUmOLb6tNEQc7hAVGgBd3TVbIc6YxwnuhQ6M
// SIG // T20OE049fClInHLR82zKwexwo1eSV32UjaAbSANa98+j
// SIG // Zwp0pTbtLS8XyOZyNxL0b7E8Z4L5UrKNMxZlHg6K3RDe
// SIG // ZPRvzkbU0xfpecQEtNP7LN8fip6sCvsTJ0Ct5PnhqX9G
// SIG // uwdgR2VgQE6wQuxO7bN2edgKNAltHIAxH+IOVN3lofvl
// SIG // RxCtZJj/UBYufL8FIXrilUEnacOTj5XJjdibIa4NXJzw
// SIG // oq6GaIMMai27dmsAHZat8hZ79haDJLmIz2qoRzEvmtzj
// SIG // cT3XAH5iR9HOiMm4GPoOco3Boz2vAkBq/2mbluIQqBC0
// SIG // N1AI1sM9MIIGBzCCA++gAwIBAgIKYRZoNAAAAAAAHDAN
// SIG // BgkqhkiG9w0BAQUFADBfMRMwEQYKCZImiZPyLGQBGRYD
// SIG // Y29tMRkwFwYKCZImiZPyLGQBGRYJbWljcm9zb2Z0MS0w
// SIG // KwYDVQQDEyRNaWNyb3NvZnQgUm9vdCBDZXJ0aWZpY2F0
// SIG // ZSBBdXRob3JpdHkwHhcNMDcwNDAzMTI1MzA5WhcNMjEw
// SIG // NDAzMTMwMzA5WjB3MQswCQYDVQQGEwJVUzETMBEGA1UE
// SIG // CBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVkbW9uZDEe
// SIG // MBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0aW9uMSEw
// SIG // HwYDVQQDExhNaWNyb3NvZnQgVGltZS1TdGFtcCBQQ0Ew
// SIG // ggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQCf
// SIG // oWyx39tIkip8ay4Z4b3i48WZUSNQrc7dGE4kD+7Rp9FM
// SIG // rXQwIBHrB9VUlRVJlBtCkq6YXDAm2gBr6Hu97IkHD/cO
// SIG // BJjwicwfyzMkh53y9GccLPx754gd6udOo6HBI1PKjfpF
// SIG // zwnQXq/QsEIEovmmbJNn1yjcRlOwhtDlKEYuJ6yGT1VS
// SIG // DOQDLPtqkJAwbofzWTCd+n7Wl7PoIZd++NIT8wi3U21S
// SIG // tEWQn0gASkdmEScpZqiX5NMGgUqi+YSnEUcUCYKfhO1V
// SIG // eP4Bmh1QCIUAEDBG7bfeI0a7xC1Un68eeEExd8yb3zuD
// SIG // k6FhArUdDbH895uyAc4iS1T/+QXDwiALAgMBAAGjggGr
// SIG // MIIBpzAPBgNVHRMBAf8EBTADAQH/MB0GA1UdDgQWBBQj
// SIG // NPjZUkZwCu1A+3b7syuwwzWzDzALBgNVHQ8EBAMCAYYw
// SIG // EAYJKwYBBAGCNxUBBAMCAQAwgZgGA1UdIwSBkDCBjYAU
// SIG // DqyCYEBWJ5flJRP8KuEKU5VZ5KShY6RhMF8xEzARBgoJ
// SIG // kiaJk/IsZAEZFgNjb20xGTAXBgoJkiaJk/IsZAEZFglt
// SIG // aWNyb3NvZnQxLTArBgNVBAMTJE1pY3Jvc29mdCBSb290
// SIG // IENlcnRpZmljYXRlIEF1dGhvcml0eYIQea0WoUqgpa1M
// SIG // c1j0BxMuZTBQBgNVHR8ESTBHMEWgQ6BBhj9odHRwOi8v
// SIG // Y3JsLm1pY3Jvc29mdC5jb20vcGtpL2NybC9wcm9kdWN0
// SIG // cy9taWNyb3NvZnRyb290Y2VydC5jcmwwVAYIKwYBBQUH
// SIG // AQEESDBGMEQGCCsGAQUFBzAChjhodHRwOi8vd3d3Lm1p
// SIG // Y3Jvc29mdC5jb20vcGtpL2NlcnRzL01pY3Jvc29mdFJv
// SIG // b3RDZXJ0LmNydDATBgNVHSUEDDAKBggrBgEFBQcDCDAN
// SIG // BgkqhkiG9w0BAQUFAAOCAgEAEJeKw1wDRDbd6bStd9vO
// SIG // eVFNAbEudHFbbQwTq86+e4+4LtQSooxtYrhXAstOIBNQ
// SIG // md16QOJXu69YmhzhHQGGrLt48ovQ7DsB7uK+jwoFyI1I
// SIG // 4vBTFd1Pq5Lk541q1YDB5pTyBi+FA+mRKiQicPv2/OR4
// SIG // mS4N9wficLwYTp2OawpylbihOZxnLcVRDupiXD8WmIsg
// SIG // P+IHGjL5zDFKdjE9K3ILyOpwPf+FChPfwgphjvDXuBfr
// SIG // Tot/xTUrXqO/67x9C0J71FNyIe4wyrt4ZVxbARcKFA7S
// SIG // 2hSY9Ty5ZlizLS/n+YWGzFFW6J1wlGysOUzU9nm/qhh6
// SIG // YinvopspNAZ3GmLJPR5tH4LwC8csu89Ds+X57H2146So
// SIG // dDW4TsVxIxImdgs8UoxxWkZDFLyzs7BNZ8ifQv+AeSGA
// SIG // nhUwZuhCEl4ayJ4iIdBD6Svpu/RIzCzU2DKATCYqSCRf
// SIG // WupW76bemZ3KOm+9gSd0BhHudiG/m4LBJ1S2sWo9iaF2
// SIG // YbRuoROmv6pH8BJv/YoybLL+31HIjCPJZr2dHYcSZAI9
// SIG // La9Zj7jkIeW1sMpjtHhUBdRBLlCslLCleKuzoJZ1GtmS
// SIG // hxN1Ii8yqAhuoFuMJb+g74TKIdbrHk/Jmu5J4PcBZW+J
// SIG // C33Iacjmbuqnl84xKf8OxVtc2E0bodj6L54/LlUWa8kT
// SIG // o/0xggSMMIIEiAIBATCBkDB5MQswCQYDVQQGEwJVUzET
// SIG // MBEGA1UECBMKV2FzaGluZ3RvbjEQMA4GA1UEBxMHUmVk
// SIG // bW9uZDEeMBwGA1UEChMVTWljcm9zb2Z0IENvcnBvcmF0
// SIG // aW9uMSMwIQYDVQQDExpNaWNyb3NvZnQgQ29kZSBTaWdu
// SIG // aW5nIFBDQQITMwAAALARrwqL0Duf3QABAAAAsDAJBgUr
// SIG // DgMCGgUAoIGuMBkGCSqGSIb3DQEJAzEMBgorBgEEAYI3
// SIG // AgEEMBwGCisGAQQBgjcCAQsxDjAMBgorBgEEAYI3AgEV
// SIG // MCMGCSqGSIb3DQEJBDEWBBTQnCdi1O5Ysn7rlTO+fKzf
// SIG // IAbUUTBOBgorBgEEAYI3AgEMMUAwPqAkgCIAVgBpAHMA
// SIG // dQBhAGwAUAByAG8AZgBpAGwAZQByAC4AagBzoRaAFGh0
// SIG // dHA6Ly9taWNyb3NvZnQuY29tMA0GCSqGSIb3DQEBAQUA
// SIG // BIIBAG13CtH2lLUrlHffK5xxXscXDTngW8uDWX47oDLa
// SIG // oW6yHJxdZO0RKEQxrCllZQH4j0rOKPMXTqparbVOkD8f
// SIG // dbTeUNSL5+CtVQGIUNDLf4zq9Ir/bwEQmhLeRQDv4IUK
// SIG // 3hjCx4BkeX0Uj3DBJwwhNhlTpUlLkncmTCiV5hrGHt3p
// SIG // Pwjliznx2rfNcqQtHgMqW3z4fl0H9/XPGmFmvjb9zrgi
// SIG // Iyjx3fton1XVpKG6/DNSf/RexXovTEhwnf50317h+m4e
// SIG // kdvsG5fQIOqQG3E4kAlX6cQQ6EZk4OkYZjh1gwXKQ994
// SIG // teO7D9zrK07WOCb11Pf1UkEs2Y8HVeSGHjBRRZyhggIf
// SIG // MIICGwYJKoZIhvcNAQkGMYICDDCCAggCAQEwgYUwdzEL
// SIG // MAkGA1UEBhMCVVMxEzARBgNVBAgTCldhc2hpbmd0b24x
// SIG // EDAOBgNVBAcTB1JlZG1vbmQxHjAcBgNVBAoTFU1pY3Jv
// SIG // c29mdCBDb3Jwb3JhdGlvbjEhMB8GA1UEAxMYTWljcm9z
// SIG // b2Z0IFRpbWUtU3RhbXAgUENBAgphAo5CAAAAAAAfMAkG
// SIG // BSsOAwIaBQCgXTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcN
// SIG // AQcBMBwGCSqGSIb3DQEJBTEPFw0xMzAzMTUwNjM0MDJa
// SIG // MCMGCSqGSIb3DQEJBDEWBBRxlvf86ixgmDsQZH1b6Wwl
// SIG // vIg07DANBgkqhkiG9w0BAQUFAASCAQAv/huXjFqWk5Rp
// SIG // vKf+TgnB+hYE6BMLBshgBfvQysgvLt7CvD4GEYoGxgAP
// SIG // zMhhJAXwGApPBaCdeVKOG3dLQ2+ba0pt7Ynppn9dBBzM
// SIG // tIv/0s1lO5fRp8c4MdH6lp7SSryoswBrmp/O4KcH5VOA
// SIG // 3Vmarc19yzBdFqFLiEXzI2VddJpY/rOl6FLyuPxburig
// SIG // WfsxduGiyWdejrZMB9MSV1O+Clm4445yZ3ijsQ/MqIao
// SIG // N9o/Mc3NPC7JgoN1de42YAgFdeHj/tzwY9wVXk8oPdhg
// SIG // 2/IGxsyH3hoZR94DsOnCvLcxfh9O9XwLYzxKEeRKmGjC
// SIG // imgzLgZS6nYOn9fdrbkK
// SIG // End signature block
